#  dummy proc  #
proc perlFilters&Misc.tcl {} {} 

#  handle perl files  #

# Open a 'require'd Perl file.
# 
proc perlFindRequire {from {to 0}} {
	set reqPat {^[ 	]*require[ 	]*(\"[^\"]+\"|\'[^\']+\'|[^ 	]+)}
	if {$to == 0} { set to $from }
	set beg [lineStart $from]
	set end [nextLineStart $to]
	set words [parseWords [getText $beg $end]]
	if {[string tolower [lindex $words 0]] != "require"} {
		error "Not a require statement"
	}
	set root [string trim [lindex $words 1] {'"}]
	return $root
}

# Open a Perl source file. 
#
proc openPerlFile {file {extensions {""}}} {
	global PerlmodeVars 
	# Determine absolute file specification
	# Ignore $extensions if $file already has an extension
	if {[string length [file extension $file]] == 0} {
		set extensions {""}
	}
	foreach ext $extensions {
		set filename [absolutePath $file$ext]
		if {![catch {openFileQuietly $filename}]} {
			message $filename
			return 
		}
	}
	if {[llength $PerlmodeVars(perlSearchPath)] == 0} { buildPerlSearchPath }
	foreach folder $PerlmodeVars(perlSearchPath) {
		foreach ext $extensions {
			set filename "$folder$file$ext"
			if {![catch {openFileQuietly $filename}]} {
				message $filename
				return 	
			}
		}
	}
	beep
	message "can't find Perl source file \"$file\""
}

# Return a list of folders in which to search for Perl library files, 
# including the lib folder in the Perl application directory and the
# $perlLibFolder folder (if it exists) .  
# The current folder is not included in the list.
#
# (The $perlLibFolder folder is assigned from the AppPaths submenu.)
#
proc buildPerlSearchPath {} {
	global PerlmodeVars 
	message "building Perl search path..."
	set folders {}
	
	# The local lib folder:
	if {[info exists PerlmodeVars(perlLibFolder)] && [string length $PerlmodeVars(perlLibFolder)] > 0} { 
		lappend folders $PerlmodeVars(perlLibFolder)
		# Search subfolders one level deep:
		eval lappend folders [listSubfolders $PerlmodeVars(perlLibFolder) 1]
	}

	# Any "*lib*" folders in the MacPerl application folder:
	set macperlPath [nameFromAppl McPL]
	set appDir [file dirname $macperlPath]
	set folders [concat $folders [list $appDir]]
	# Bug:  'glob' is case sensitive!
	foreach folder [glob -dir $appDir "*\[Ll\]ib*"] {
		lappend folders $folder
		# Search subfolders one level deep:
		eval lappend folders [listSubfolders $folder 1]
	}

	# Make sure each folder ends with a colon
	set $PerlmodeVars(perlSearchPath) {}
	foreach folder $folders {
		set folder "[string trimright $folder {:}]:"
		lappend PerlmodeVars(perlSearchPath) [list $folder]
	}
}
#  text filters  #

#############################################################################
# Run a preattached Perl text-filter script selected from the menu:
#
proc textFiltersProc {menu name} {
	global PerlmodeVars perlFilters scriptFile scriptStart
	
	perlFileAsFilter $perlFilters($menu:$name)
}

#############################################################################
# Reuse the previous (buffer or file) filter:
#
proc repeatLastFilter {} {
	global PerlmodeVars scriptFile scriptStart perlMenu 
	if {$PerlmodeVars(perlPrevScript) != {}} {
		set stype [lindex $PerlmodeVars(perlPrevScript) 0]
		set name [lindex $PerlmodeVars(perlPrevScript) 1]
		if {$stype == "file"} {
			perlFileAsFilter $name
		} elseif {$stype == "buffer"} {
	    	perlBufferAsFilter $name
		} else {
			message "Bogus filter name : \"$PerlmodeVars(perlPrevScript)\""
			set PerlmodeVars(perlPrevScript) {}
			synchroniseModeVar perlLastFilter $PerlmodeVars(perlPrevScript)
			enableMenuItem $perlMenu repeatLastFilter 0
		}
	}
}

#############################################################################
# Ask for a file containing a Perl script to use as a filter:
#
proc selectFileAsFilter {} {
	global PerlmodeVars scriptFile scriptStart 
	if {! [catch {getfile "Select a MacPerl script"} path]} {
		perlFileAsFilter $path
	}
}

#############################################################################
# Ask for an Alpha buffer containing a Perl script to use as a filter:
#
proc selectBufferAsFilter {} {
	global PerlmodeVars scriptFile scriptStart 
	
	set windows [winNames]
	set current [lindex $windows 0]
	if {[llength $windows] > 1} {
	    set name [listpick [lsort $windows]]
	    if {[string length $name]} {
	    	# get the full name of the chosen window
	    	set wname [lindex [winNames -f] [lsearch -exact $windows $name]]
	    	perlBufferAsFilter $wname
	   	}
	}
}


#############################################################################
# Prepare the contents of a text window for use as a text-filter script. 
# (calls perlTextFilter to actually run the script)
# 
proc perlBufferAsFilter {wname} {
	global PerlmodeVars scriptFile scriptStart  perlMenu perlName

	set ok [regexp {(.*):([^:]*)} $wname pathname dirname name]
	if {!$ok} {	set name $wname	}
	
	if {[lsearch [winNames -f] $wname] >= 0} {
		set coreScript [getText -w $wname 0 [maxPos -w $wname]]
		
		# Does it have any text in it?
	    if {[string length $coreScript]} {
		    set scriptFile $wname
		    set scriptStart 1
			set script [wrapFilterScript $coreScript]
			set PerlmodeVars(perlPrevScript) [list "buffer" $wname]
			synchroniseModeVar perlLastFilter $PerlmodeVars(perlPrevScript) 
			enableMenuItem $perlMenu repeatLastFilter 1
			message "Running buffer \"$name\" as text filter ..."
			
			perlTextFilter $script
		}
	} else {
		set PerlmodeVars(perlPrevScript) {}
		synchroniseModeVar perlLastFilter $PerlmodeVars(perlPrevScript) 
		enableMenuItem $perlMenu repeatLastFilter 0

		alertnote "Couldn't find buffer : $name"
	}
}

#############################################################################
#  Take a Perl script and add commands to take the file STDIN as standard
#  input and STDOUT as standard output.  This allows scripts written as
#  Unix command-line filters to be used in the (non-MPW) Mac environment as
#  text filters.
#
#  If there's already a #! line in the script, then the new commands
#  are added after that line.  If there was no #! line in the first place,
#  one is added, in case MacPerl is set up to require it (can't hurt...) 
#
#  $filterHeadLen counts the number of lines we add to the top of the
#  original script, so that we can allow for it in interpreting error
#  messages issued by MacPerl.
#
#  *** As of MacPerl 4.1.4, this business is pretty much obsolete ***
#
proc wrapFilterScript {coreScript} {
	global PerlmodeVars scriptStart filterHeadLen 
	set interpPat {(#![	 !-~]*)}

	if {[regexp -indices -- $interpPat $coreScript allofit cmdln]} {
		set endPos [lindex $cmdln 1]
		set filterHead [string range $coreScript 0 [expr $endPos+1]]
		set coreScript [string range $coreScript [expr $endPos+2] end]
		set filterHeadLen 0
		incr scriptStart [expr [llength [split $filterHead "\n\r"]] -2]
	} else {
		set filterHead "#!/bin/perl\r\n"
		set filterHeadLen 2
	}
		
	set script $filterHead
	append script $coreScript
	
	# for debugging purposes, save the script on disk
	#
	writeScript $script
	return $script
}		

#############################################################################
#  Paste result of the filter operation in place of the input text, or in
#  a new window (depending on the flag $PerlmodeVars(perloverwriteSelection)
#
proc pasteFilterResult {text} {
	global PerlmodeVars
	set perlOutputWindow {* Perl Output *}
	
    if {!$PerlmodeVars(perloverwriteSelection)} {
		if {$PerlmodeVars(perlRecycleOutput) && 
		    [lsearch [winNames] $perlOutputWindow] >= 0} {			    
			bringToFront $perlOutputWindow
		} else {
			new -n $perlOutputWindow
		}
	}
	
    if {$PerlmodeVars(perlapplyToBuffer) || $PerlmodeVars(perlRecycleOutput)} {
    	set from 0
    	set to [maxPos]
    } else {
    	set from [getPos] 
    	set to [selEnd]
    }    
	replaceText $from $to $text
	
    if {!$PerlmodeVars(perloverwriteSelection) || $PerlmodeVars(perlapplyToBuffer)} {
    	catch {shrinkWindow 2}
		goto [minPos]
    } else {
		catch shrinkWindow
		goto $from
	}
    if {!$PerlmodeVars(perloverwriteSelection)} { setWinInfo dirty 0 }
}    

#############################################################################
# Prepare the contents of a disk file for use as a text-filter script. 
# (calls perlTextFilter to actually run the script)
# 
proc perlFileAsFilter {path} {
	global PerlmodeVars scriptFile scriptStart  perlMenu 
	
	regexp {(.*):([^:]*)} $path pathname dirname name
	
	if {![catch {readFile $path} coreScript]} {
		set scriptFile $path
		set scriptStart 1
		set script [wrapFilterScript $coreScript]
		set PerlmodeVars(perlPrevScript) [list "file" $path]
		synchroniseModeVar perlLastFilter $PerlmodeVars(perlPrevScript) 
		enableMenuItem $perlMenu repeatLastFilter 1
		message "Running file \"$name\" as text filter ..."
		
		perlTextFilter $script
    } else {
		set PerlmodeVars(perlPrevScript) {}
		synchroniseModeVar perlLastFilter $PerlmodeVars(perlPrevScript) 
		enableMenuItem $perlMenu repeatLastFilter 0
		
		alertnote "Couldn't read the script file : $path"
		return
    }
}

#############################################################################
# Run a Perl script as a command-line text filter, arranging for a text
# buffer to be attached as standard input.  The calling routine should already
# have processed the script with wrapFilterScript.  This routine actually
# sends the script and takes care of writing the input and reading the output 
# files.
# 
proc perlTextFilter {script {args {}} {flags {}}} {
	global PerlmodeVars filterHeadLen scriptFile scriptStart ALPHA
	global perlName

	set perlName [file tail [app::launchBack McPL]]
	if {![string length $perlName]} {
		alertnote "Couldn't run MacPerl"
		error "Couldn't run MacPerl"
    }
	writeStdin

	if {$PerlmodeVars(perluseDebugger)} {
		append flags "debug"
	}
	if {$PerlmodeVars(perlpromptForArgs)} { 
		append args " [getCmdlineArgs]"
	}
	
	sendCloseWinName $perlName $perlName
	sendCloseWinName $perlName "Perl Debug"
	
	if {$PerlmodeVars(perluseDebugger)} {
		switchTo $perlName
		perlDoScript $perlName [scriptPath] $args [list [stdinPath]] $flags
		set err [getMacPerlError]

	} else {
		watchCursor
		set reply [perlDoScriptBatch $perlName [scriptPath] $args [list [stdinPath]]]
		set err [getBatchError $reply]
	}
	
	switchTo $ALPHA
	
	if {$err == 0} {
		if {$PerlmodeVars(perluseDebugger)} {
			set outp [sendGetText $perlName $perlName]
		} else {
#			set outp [parseReplyOutp $reply]
			set outp [parseReplyResult $reply]
		}
		pasteFilterResult $outp
	}
}


#############################################################################
#  Support procs  #
#############################################################################


#############################################################################
# Open a file from the MacPerl application folder - used by "Open Special"
#
proc perlOpenFile {menu name} {
    set filename [macperlFolder]$name
    if {[file exists $filename]} {
	    edit $filename
	} else {
	    alertnote "That file doesn't exist yet"
	}
}

#############################################################################
# Prompt the user to enter a string containing command-line args.
#
proc getCmdlineArgs {} {
	global PerlmodeVars perlCmdlineArgs
	if {![catch {prompt "Command-line arguments (if any):" $PerlmodeVars(perlCmdlineArgs)} args]} {
		synchroniseModeVar perlCmdlineArgs $args
	} else {
		error "getCmdlineArgs: User cancelled"
	}
	return $args
}

#############################################################################
#  Add a #!/bin/perl line to the script if it doesn't contain one already.
#  (MacPerl puts up dialog if this line is missing when it expects it,
#  hanging the DoScript and leaving us stuck.)
#
proc wrapSelectScript {coreScript} {
	global PerlmodeVars scriptStart filterHeadLen
	set interpPat {(#![	 !-~]*)}

	if {[regexp -indices $interpPat $coreScript allofit cmdln]} {
		set endPos [lindex $cmdln 1]
		set filterHead [string range $coreScript 0 [expr $endPos+1]]
		set script $coreScript
		set filterHeadLen 0
		incr scriptStart [expr [llength [split $filterHead "\n\r"]] -2]
	} else {
		set script "#!/bin/perl\r\n"
		append script $coreScript
		set filterHeadLen 1
	}
	
	# for debugging purposes, save the script on disk
	#
	writeScript $script
	return $script
}		

#####################################
# If 'applyToBuffer' is set, select the entire buffer. Otherwise, expand
# the selection to encompass complete lines. Select the current line
# containing the insertion point if there is no selection. A special hack
# is required for line select mode (mouse drag over lines to the left of
# col 1) because posToRowCol places \r in col 0 of the next row.
# RBC 02-MAR-1999
#


proc completeSelection {} {
    
    global PerlmodeVars filterInput
    set filterInput "buffer \"[lindex [winNames] 0]\""
    if {$PerlmodeVars(perlapplyToBuffer)} {
	set start [minPos]
	set end [maxPos]
    } else {
	beginningLineSelect  ; # extend selection backwards
	if {[pos::compare [lindex [posToRowCol [selEnd]] 1] != 0]} {
	    endLineSelect
	    forwardCharSelect}
# if we are in col 0, we've already selected a whole line. Otherwise, extend
# the selection to the end of current line. forwardCharSelect grabs the \r.   
	set start [getPos]
	set end   [selEnd]
	set startLine [lindex [posToRowCol $start] 0]
	set endLine   [lindex [posToRowCol $end] 0]
	if {[pos::compare $endLine > $startLine]} {
	    set filterInput "lines $startLine to $endLine of $filterInput"
	} else {
	    set filterInput "line $startLine of $filterInput"
	}
    }
    return [list $start $end]
}

#############################################################################
#  writeStdin: Extend the selection, as appropriate, and write it to the 
#     STDIN file in the MacPerl directory.
#
#  writeScript: Write the SCRIPT file in the MacPerl directory.  MacPerl will
#     read the script from this file. 
#
#  -nonewline added to 'puts' so an extra \r isn't appended. (RBC 02-MAR-1999)
proc writeStdin {} {
    set res [completeSelection]
    set tmpfid [open [stdinPath] "w+"]
    puts -nonewline $tmpfid [eval getText $res]
    close $tmpfid
}

# This is unnecessary now, but maybe it'll still useful to save the script
# file for debugging.
#
proc writeScript {script} {
    set tmpfid [open [scriptPath] "w+"]
    puts $tmpfid $script 
    close $tmpfid
}
